#include <iostream>
#include <vector>
using namespace std;

struct Point
{
    int x, y;
};


int orientation(Point p, Point q, Point r)
{
    int val = (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);

    if (val == 0)
        return 0;             
    return (val > 0) ? 1 : 2; 
}

vector<Point> convexHull(Point points[], int n)
{
    if (n < 3)
        return{};

    vector<Point> hull;

    int l = 0;
    for (int i = 1; i < n; i++)
        if (points[i].x < points[l].x)
            l = i;

    int p = l, q;
    do
    {
        hull.push_back(points[p]);
        q = (p + 1) % n;
        for (int i = 0; i < n; i++)
        {
            if (orientation(points[p], points[i], points[q]) == 2)
                q = i;
        }

        p = q;

    }

    while (p != l);
    
    return hull;
}
double calculateArea(Point points[], int n)
{
    double area = 0.0;

    for (int i = 0; i < n; i++)
    {
        int j = (i + 1) % n; 
        area += (points[i].x * points[j].y) - (points[j].x * points[i].y);
    }

    return abs(area) / 2.0; 
}
int main()
{int n;
cin>>n;
Point* points = new Point[n];
    for(int i=0;i<n;i++)
    {
        cin>>points[i].x>>points[i].y;
    }
   vector<Point> hull = convexHull(points, n);
   double smallestArea = calculateArea(hull.data(), hull.size());
   double mini=smallestArea;
    for (int i = 0; i < n; i++)
    {
        vector<Point> subset;
        for (int j = 0; j < n; j++)
        {
            if (j != i) 
            {
                subset.push_back(points[j]);
            }
        }

        vector<Point> subsetHull = convexHull(subset.data(), subset.size());
        double subsetArea = calculateArea(subsetHull.data(), subsetHull.size());
        if(subsetArea<mini)mini=subsetArea;
        
    }

    cout << mini;

    delete[] points; 

    return 0;
}